<?php
/*************************************************************************************/
/* registering faqs post type.* /
/**************************************************************************************/
add_action( 'init', 'create_post_types_faqs' );
function create_post_types_faqs() {
    register_post_type( 'faqs', array(
            'labels'              => array(
                'name'               => __( 'الأسئلة الشائعة', 'm7md' ),
                'singular_name'      => __( 'الأسئلة الشائعة', 'm7md' ),
                'add_new'            => __( 'إضافه سؤال', 'm7md' ),
                'add_new_item'       => __( 'سؤال جديد', 'm7md' ),
                'all_items'          => __( 'الأسئلة الشائعة', 'm7md' ),
                'edit_item'          => __( 'تحرير سؤال', 'm7md' ),
                'new_item'           => __( 'سؤال جديد', 'm7md' ),
                'view_item'          => __( 'معاينة سؤال', 'm7md' ),
                'search_items'       => __( 'البحث عن سؤال', 'm7md' ),
                'not_found'          => __( 'لا يوجد سؤال', 'm7md' ),
                'not_found_in_trash' => __( 'لا يوجد سؤال', 'm7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-admin-generic',
            'hierarchical'        => false,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 6,
            'supports'            => array(
                'thumbnail',
                'title',
                'editor',
                'excerpt',
                //'tags',
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'faqs' ),
        )
    );
}



// hook into the init action and call create_faqs_taxonomies when it fires
add_action( 'init', 'create_faqs_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_faqs_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام الأسئلة الشائعة', 'm7md' ),
        'all_items'         => __( 'كافة الأقسام', 'm7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'faqsCat' ),
    );

    register_taxonomy( 'faqs_cat', array( 'faqs' ), $args );
}
